function output = fct_draw_subsample_data(data,k,replacement);

% CREATE INDIVIDUAL LEVEL DATA
    Ntot = sum(data(:,3));
    data_individual = zeros(Ntot,2);
    K = 0;
    for i = 1:length(data)
        Npeople = data(i,3);
        data_individual(K+1:K+Npeople,1:2) = repmat(data(i,1:2),Npeople,1);
        K = K+Npeople;
    end

% DRAW A SUBSAMPLE
    %k = floor(Ntot/2);
    y = randsample(Ntot,k,replacement);
    data_sub = data_individual(y,:);

    tmin = min(data_individual(:));
    tmax = max(data_individual(:));
    tgrid_out = [tmin:1:tmax];
    [tx ty]   = meshgrid(tgrid_out,tgrid_out);
    data_subsample(:,1) = tx(:);
    data_subsample(:,2) = ty(:);
    data_subsample(:,3) = 0*data_subsample(:,2);
    I1        = length(tgrid_out); 
    for i = 1: k
        ki = (data_sub(i,1)-tmin)*I1 + (data_sub(i,2)-tmin+1);
        data_subsample(ki,3) = data_subsample(ki,3)+1;
    end
    selx = data_subsample(:,3)>0;
    data_subsample = data_subsample(selx,:);
% OUTPUT    
    output.data = data_subsample;
return